/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.Animation;
import Entity.MapObject;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Gate
extends MapObject {
    private ArrayList<BufferedImage[]> sprites;
    private final int[] numFrames = new int[]{1, 9, 1};
    public int height = 30;
    public int width = 30;
    public int cheight = 20;
    public int cwidth = 20;
    private static final int CLOSED = 0;
    private static final int OPENING = 1;
    private static final int OPEN = 2;

    public Gate(TileMap tm) {
        super(tm);
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Gate/GateSpriteSheet.png"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 3) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = spritesheet.getSubimage(j * this.height, i * this.height, this.width, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.currentAction = 0;
        this.animation.setFrames(this.sprites.get(0));
        this.animation.setDelay(200L);
    }

    public boolean checkContact(Player player) {
        if (this.getx() - player.getx() < 20 && this.getx() - player.getx() > 0 || this.getx() - player.getx() > -20 && this.getx() - player.getx() < 0) {
            if (this.currentAction != 1) {
                this.currentAction = 1;
                this.animation.setFrames(this.sprites.get(1));
                this.animation.setDelay(400L);
                this.width = 30;
            }
            if (this.currentAction != 2) {
                this.currentAction = 2;
                this.animation.setFrames(this.sprites.get(2));
                this.animation.setDelay(400L);
                this.width = 30;
            }
            if (player.up) {
                return true;
            }
        }
        return false;
    }

    public void update() {
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        this.facingRight = true;
        this.animation.update();
    }

    @Override
    public void draw(Graphics2D graphics) {
        this.setMapPosition();
        super.draw(graphics);
    }
}

